<?php

namespace App\Jobs\Exports;

use App\Models\FileExport;
use Facades\App\Services\Zoom\ZoomDataDownloadService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ZoomApiDataExportJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     * @param int $reportId   The ID of the report.
     * @param string $reportType  The type of report.
     *
     * @return void
     */
    public function __construct(
        protected int $reportId = 0,
        protected string $reportType = ''
    ) {}

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        if ($this->reportType === 'zoom_rooms') {
            $filename = ZoomDataDownloadService::getZoomRoomsDataAsJsonFile();
        } else {
            $filename = ZoomDataDownloadService::getZoomLocationsDataAsJsonFile();
        }

        $reportUpdateData = ['report_url' => $filename];
        FileExport::where("id", $this->reportId)->update($reportUpdateData);
    }
}
