<?php

namespace App\Jobs\Exports;

use App\Models\FileExport;
use App\Services\Reports\DuplicateAssetsService;
use Facades\App\Services\ExportManagement\ExportManagementService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DuplicateAssetsExportJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Request object
     *
     * @var Illuminate\Http\Request;
     */
    private $request;

    /**
     * The user id.
     *
     * @var integer
     */
    private $userId;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $duplicatedAssetsService;

    public function __construct(array $request, $duplicatedAssetsService)
    {
        $this->request =  $request;
        $this->userId =  auth()->user()->id;
        $this->duplicatedAssetsService =  $duplicatedAssetsService;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $datas = collect();
        $reportData = ['report_name' => 'Duplicated Assets', 'user_id' => $this->userId, 'report_type' => 'duplicated_assets_report'];
        $reportId = FileExport::create($reportData)->id;

        $exportData = $this->duplicatedAssetsService->getDuplicatedAssetsExportData($this->request);

        $matchedAssets = $exportData->flatMap(function ($item) {
            return explode(',', $item->matching_assets);
        })->toArray();

        $dataToExport = $this->duplicatedAssetsService->formatExportAssetDuplicationData($exportData, $matchedAssets);
        $datas->push($dataToExport);

        $filename =  ExportManagementService::exportForLater($datas->toArray(), 'duplicated_assets_report_');
        $reportUpdateData = ['report_url' => $filename];
        FileExport::where("id", $reportId)->update($reportUpdateData);
    }
}
