<?php

namespace App\Http\Traits;

use App\User;
use Illuminate\Support\Facades\Auth;

/**
 * It is used support jira plugin status update
 */
trait JiraPluginTrait
{
	public function getAuthenticatedUser()
	{
		//Normal Usage
		if ($userId = Auth::id()) {
			$user = User::find($userId);

			return $user;
		}

		//Jira APP logged in user existing in Teqtivity
		if (request('jira_user_email')) {
			$user = User::where('email', request('jira_user_email'))->first();
			if ($user) {
				return $user;
			}
		}

		//Jira APP logged in user doesn't exist in Teqtivity
		if (request('jira_user_name')) {
			//Making an Collection with Jira user details and return the collection
			$userData = collect(['id' => 0, 'first_name' => request('jira_user_name'), 'last_name' => '', 'email' => request('jira_user_email')]);
			$user = (object) $userData->toArray();

			return $user;
		}

		//zendesk APP logged in user existing in Teqtivity
		if (request('zendesk_user_email')) {
			$user = User::where('email', request('zendesk_user_email'))->first();
			if ($user) {
				return $user;
			}

			//zendesk APP logged in user doesn't exist in Teqtivity
			if (request('zendesk_user_name')) {
				$userData = collect(['id' => 0, 'first_name' => request('zendesk_user_name'), 'last_name' => '', 'email' => request('zendesk_user_email')]);
				$user = (object) $userData->toArray();
				return $user;
			}
		}

		//Slackbot user existing in Teqtivity
		if (request('slack_user_email')) {
			$user = User::where('email', request('slack_user_email'))->first();
			if ($user) {
				return $user;
			}
		}

		return [];
	}
}
