<?php

namespace App\Http\Traits;

use Carbon\Carbon;

trait DepreciationValueTrait
{
    /**
     * query for getting sum of depreciation value of provided assets
     *
     * @param $assets
     *
     * @return mixed
     */
    public function getDepreciationValue($assets)
    {
        $depreciationValue = $assets
            ->join('technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id')
            ->selectRaw('SUM(CEIL(CASE WHEN TIMESTAMPDIFF(YEAR, assets.created_at, ?) > 0
                THEN ROUND(
                    COALESCE(assets.asset_original_value, technical_specs.original_value) - 
                    (COALESCE(assets.asset_original_value, technical_specs.original_value) * 20 / 100) * TIMESTAMPDIFF(YEAR, assets.created_at, ?), 2)
                ELSE COALESCE(assets.asset_original_value, technical_specs.original_value) END)) as total_depreciation_value'
                , [Carbon::now(), Carbon::now()])
            ->whereNotNull('technical_specs.original_value')
            ->value('total_depreciation_value');
        return $depreciationValue;
    }

    /**
     * query for  sum of original Value of provided assets
     * 
     * @param $assets
     * 
     * @return mixed
     */
    public function getOriginalValue($assets)
    {
        $originalValue = $assets
        ->join('technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id')
        ->selectRaw('ROUND(SUM(CASE WHEN assets.asset_original_value IS NOT NULL THEN assets.asset_original_value ELSE COALESCE(technical_specs.original_value, 0) END)) as total_original_value')
        ->whereNotNull('technical_specs.original_value')
        ->value('total_original_value');
        
        return $originalValue;
    }

}
