<?php

namespace App\Http\Traits;

use Illuminate\Http\Request;
use App\Http\Responses\ReportJsonResponse;

trait DataAndExportControllerTrait
{
    /**
     * Taking the data to the report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        $data = [];
        $filteredData = $this->service->data();

        if (!empty($filteredData['result'])) {
            $data = $this->service->getReportData($filteredData['result'], request('start'));
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }

    /**
     * Exporting the data of the report.
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $data = [];
        $datas = collect();

        $result =  $this->service->exportData();
        $requiredColumns = [];

        if (method_exists($this, 'getExportColumns') === true) {
            $requiredColumns = $this->getExportColumns();
        }

        $result->chunk(5000, function ($resultChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($resultChunks, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
