<?php

namespace App\Http\Traits\Common;

use App\Http\Responses\ReportJsonResponse;

trait DataTableControllerTrait
{
    /**
     * Taking the data to the reports
     *
     * @return Http\Response
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $result       = $filteredData['result'];
        $totalData    = $filteredData['count'];
        $data         = [];

        if (!empty($result)) {
            $data = $this->service->getReportData($result, request('start'));
        }

        return new ReportJsonResponse(request('draw'), $data, $totalData);
    }

    /**
     * Export report result to csv
     *
     * @return object
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $dataCollection     = collect();
        $allData            = $this->service->exportData();

        $allData->chunk(5000, function ($chunkData) use ($dataCollection) {
            $dataCollection->push($this->service->getReportExportData($chunkData));
        });

        return exportToCsv($dataCollection->toArray());
    }
}
