<?php

namespace App\Http\Responses;

use Illuminate\Contracts\Support\Responsable;

class ReportJsonResponse implements Responsable
{

    public function __construct(protected $draw, protected $data, protected $dataCount, protected $additonalValue = null)
    {
    }

    public function toResponse($request)
    {
        return response()->json([
            "draw" => intval($this->draw),
            "recordsTotal" => intval($this->dataCount),
            "recordsFiltered" => intval($this->dataCount),
            "data" => $this->data,
            "value" => $this->additonalValue,
        ]);
    }
}
