<?php

namespace App\Http\Responses;

use Illuminate\Contracts\Support\Responsable;

class DataTableJsonResponse implements Responsable
{
    protected $route;
    protected $message;

    public function __construct(protected $draw, protected $data, protected $dataCount)
    {
        $this->draw = $draw;
        $this->data = $data;
        $this->dataCount = $dataCount;
    }

    public function toResponse($request)
    {
        return response()->json([
            "draw" => intval($this->draw),
            "recordsTotal" => intval($this->dataCount),
            "recordsFiltered" => intval($this->dataCount),
            "data" => $this->data,
        ]);
    }
}
