<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.user');
        return [
            'id'              => $this->when(in_array('id', $returnFields), $this->id),
            'first_name'      => $this->when(in_array('first_name', $returnFields), $this->first_name ?? ''),
            'last_name'       => $this->when(in_array('last_name', $returnFields), $this->last_name ?? ''),
            'email'           => $this->when(in_array('email', $returnFields), $this->email),
            'employee_id'     => $this->when(in_array('employee_id', $returnFields), $this->employee_id ?? ''),
            'hire_date'       => $this->when(in_array('hire_date', $returnFields), $this->hire_date),
            'terminated_date' => $this->when(in_array('terminated_date', $returnFields), $this->terminated_date),
            'status'          => $this->when(in_array('status', $returnFields), $this->status == 1 ? 'Active' : 'Terminated'),
            'legalhold'       => $this->when(in_array('legalhold', $returnFields), $this->legalhold == 1 ? 'Yes' : 'No'),
            'user_type'       => $this->when(in_array('user_type', $returnFields), optional($this->employeeType)->name),
            'teqtivity_role'  => $this->when(in_array('teqtivity_role', $returnFields), optional($this->userType)->name),
            'title'           => $this->when(in_array('position', $returnFields), optional($this->position)->name),
            'department'      => $this->when(in_array('department', $returnFields), optional($this->department)->name),
            'work_location'   => $this->when(in_array('work_location', $returnFields), $this->city),
            'created_date'    => $this->when(in_array('created_date', $returnFields), $this->created_at ? parse_date_from_db_datetime($this->created_at) : ''),
            'modified_date'   => $this->when(in_array('modified_date', $returnFields), $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : ''),
        ];
    }
}
