<?php

namespace App\Http\Resources\TechSpec;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Hardware\HardwareRelationResource;
use App\Http\Resources\Manufacturer\ManufacturerRelationResource;
use App\Http\Resources\AssetType\AssetTypeRelationResource;

class TechSpecRelationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.techSpec');
        return [
            'id' => $this->when(in_array('id', $returnFields), $this->id),
            'details' => $this->when(in_array('details', $returnFields), $this->details ?? ''),
            'original_value' => $this->when(in_array('original_value', $returnFields), $this->original_value ?? ''),
            'new_value' => $this->when(in_array('new_value', $returnFields), $this->new_value ?? ''),
            'life_of_asset' => $this->when(in_array('life_of_asset', $returnFields), $this->life_of_asset ?? ''),
            'created_date'  => $this->when(in_array('created_date', $returnFields), $this->created_at ? parse_date_from_db_datetime($this->created_at) : ''),
            'modified_date' => $this->when(in_array('modified_date', $returnFields), $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : ''),
        ];
    }
}
