<?php

namespace App\Http\Resources\SiteCode;

use Illuminate\Http\Resources\Json\ResourceCollection;

class SiteCodeCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $pagination = [
            'total' => $this->total(),
            'count' => $this->count(),
            'limit' => (int) $this->perPage(),
            'current_page' => $this->currentPage(),
            'total_pages' => $this->lastPage(),
        ];

        return [
            'items' => $this->collection,
            'pagination' => $pagination,
        ];
    }
}
