<?php

namespace App\Http\Resources\Manufacturer;

use Illuminate\Http\Resources\Json\JsonResource;

class ManufacturerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.manufacturers');

        return [
            'id' => $this->when(in_array('created_date', $returnFields), $this->id),
            'name' => $this->when(in_array('created_date', $returnFields), $this->name),
            'created_date'  => $this->when(in_array('created_date', $returnFields), $this->created_at ? parse_date_from_db_datetime($this->created_at) : ''),
            'modified_date' => $this->when(in_array('modified_date', $returnFields), $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : ''),
        ];
    }
}
