<?php

namespace App\Http\Resources\Location;

use Illuminate\Http\Resources\Json\JsonResource;

class LocationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.location');

        return [
            'id'            => $this->when(in_array('id', $returnFields), $this->id),
            'name'          => $this->when(in_array('name', $returnFields), $this->room_name ?? ''),
            'location_type' => $this->when(in_array('location_type', $returnFields), optional($this->locationType)->location_type_name),
            'status'        => $this->when(in_array('status', $returnFields),  $this->status == 1 ? 'Active' : 'Inactive'),
            'site_code'     => $this->when(in_array('site_code', $returnFields), optional($this->siteCode)->code),
            'building'      => $this->when(in_array('building', $returnFields), $this->building ?? ''),
            'address'       => $this->when(in_array('address', $returnFields), $this->address ?? ''),
            'floor'         => $this->when(in_array('floor', $returnFields), $this->floor ?? ''),
            'room_capacity' => $this->when(in_array('room_capacity', $returnFields), $this->room_capacity ?? ''),
            'country'       => $this->when(in_array('country', $returnFields), optional(optional($this->siteCode)->country)->name),
            'region'        => $this->when(in_array('region', $returnFields), optional(optional($this->siteCode)->region)->name),
            'created_date'  => $this->when(in_array('created_date', $returnFields), $this->created_at ? parse_date_from_db_datetime($this->created_at) : ''),
            'modified_date' => $this->when(in_array('modified_date', $returnFields), $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : ''),
        ];
    }
}
