<?php

namespace App\Http\Resources\Hardware;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Manufacturer\ManufacturerRelationResource;
use App\Http\Resources\AssetType\AssetTypeRelationResource;

class HardwareResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.hardware');
        return [
            'id'            => $this->when(in_array('id', $returnFields), $this->id),
            'name'          => $this->when(in_array('name', $returnFields), $this->name),
            'manufacturer'  => $this->when(in_array('manufacturer', $returnFields), new ManufacturerRelationResource($this->manufacturer)),
            'asset_type'    => $this->when(in_array('asset_type', $returnFields), new AssetTypeRelationResource($this->assetType)),
            'created_date'  => $this->when(in_array('created_date', $returnFields), $this->created_at ? parse_date_from_db_datetime($this->created_at) : ''),
            'modified_date' => $this->when(in_array('modified_date', $returnFields), $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : ''),
        ];
    }
}
