<?php

namespace App\Http\Resources\Hardware;

use Illuminate\Http\Resources\Json\JsonResource;

class HardwareRelationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'created_date'  => $this->created_at ? parse_date_from_db_datetime($this->created_at) : '',
            'modified_date' => $this->updated_at ? parse_date_from_db_datetime($this->updated_at) : '',
        ];
    }
}
