<?php

namespace App\Http\Resources\DiscoveryTools\MobileIron;

use Illuminate\Http\Resources\Json\JsonResource;

class DeviceNotCreatedResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'serial_number' => $this->serial_no ?? '',
            'computer_name' => $this->name ?? '',
            'os_version' => $this->os_version ?? '',
            'mdm_user_email_address' => $this->email ?? '',
            'user_status' => $this->user ? ($this->user->status == 1 ? 'Active' : 'Terminated') : 'nil',
            'make_model' => $this->manufacturer ? $this->manufacturer.' '.$this->model : $this->model,
            'user_work_location' => $this->user ? $this->user->location : '',
            'mac_address' => $this->mac_address ?? '',
            'last_check_in' =>$this->checkin_date ?? ''
        ];
    }
}
