<?php

namespace App\Http\Resources\AssetStatus;

use Illuminate\Http\Resources\Json\JsonResource;

class AssetStatusRelationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.asset_types');

        return [
            'id' => $this->when(in_array('created_date', $returnFields), $this->id),
            'name' => $this->when(in_array('created_date', $returnFields), $this->name)
        ];
    }
}
