<?php

namespace App\Http\Resources\Asset;

use App\Http\Resources\AssetStatus\AssetStatusResource;
use App\Http\Resources\AssetType\AssetTypeResource;
use App\Http\Resources\Carrier\CarrierResource;
use App\Http\Resources\Hardware\HardwareRelationResource;
use App\Http\Resources\TechSpec\TechSpecRelationResource;
use App\Http\Resources\Location\LocationResource;
use App\Http\Resources\Manufacturer\ManufacturerResource;
use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class AssetResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $returnFields = $request->has('selected_columns') ? explode(',', $request->selected_columns) : config('api-return-fields.asset');

        return [

            'id'                            => $this->when(in_array('id', $returnFields), $this->id),

            'asset_type'                    => $this->when(in_array('asset_type', $returnFields), optional($this->assetType)->name),
            'manufacturer'                  => $this->when(in_array('manufacturer', $returnFields), optional(optional($this->makeAndModel)->manufacturer)->name),
            'hardware_standard'             => $this->when(in_array('hardware_standard', $returnFields), optional($this->makeAndModel)->makeModelName),
            'technical_specs'               => $this->when(in_array('technical_specs', $returnFields), optional($this->technicalSpec)->details),
            'asset_tag'                     => $this->when(in_array('asset_tag', $returnFields), $this->asset_tag),
            'serial_no'                     => $this->when(in_array('serial_no', $returnFields), $this->serial_no),
            'imei'                          => $this->when(in_array('imei', $returnFields), $this->imei ?? ''),
            'carrier'                       => $this->when(in_array('carrier', $returnFields), optional($this->carrier)->name),
            'asset_age'                     => $this->when(in_array('asset_age', $returnFields), $this->asset_age ?? ''),
            'parent_asset'                  => $this->when(in_array('parent_asset_tag', $returnFields), $this->parentAsset->asset_tag ?? ''),
            'child_asset'                   => $this->when(in_array('child_asset', $returnFields), $this->childrenAsset),


            'asset_status'                  => $this->when(in_array('asset_status', $returnFields), optional($this->assetStatus)->name),
            'location'                      => $this->when(in_array('location', $returnFields), optional($this->location)->room_name),
            'user'                          => $this->when(in_array('user', $returnFields), optional($this->user)->first_name . ' ' . optional($this->user)->last_name),
            'network_code'                  => $this->when(in_array('location', $returnFields), ''),

            'created_date'                  => $this->when(in_array('created_date', $returnFields), parse_api_date($this->getRawOriginal('created_at'))),
            'modified_date'                 => $this->when(in_array('modified_date', $returnFields), $this->updated_at ?? ''),
            'support_end_date'              => $this->when(in_array('support_end_date', $returnFields), $this->technicalSpec ? parse_date_to_month_year($this->technicalSpec->support_end_date) : ''),
            'loaner_return_date'            => $this->when(in_array('loaner_return_date', $returnFields), $this->loaner_return_date ?? ''),
            'loaner_retention_date'         => $this->when(in_array('loaner_retention_date', $returnFields), $this->loaner_retention_date ?? ''),
            'lease_start_date'              => $this->when(in_array('lease_start_date', $returnFields), $this->lease_start_date ?? ''),
            'lease_end_date'                => $this->when(in_array('lease_end_date', $returnFields), $this->lease_end_date ?? ''),
            'warranty_end_date'             => $this->when(in_array('warranty_end_date', $returnFields), $this->warranty_end_date ?? ''),


            'po_no'                         => $this->when(in_array('po_no', $returnFields), $this->po_id),
            'tracking_id'                   => $this->when(in_array('tracking_id', $returnFields), $this->assetTracking->tracking_number ?? ''),
            'asset_original_value'          => $this->when(in_array('asset_original_value', $returnFields), $this->technicalSpec->original_value ?? ''),
            'asset_depreciated_value'       => $this->when(in_array('asset_depreciated_value', $returnFields), $this->depreciated_value ?? ''),

            'make_and_model'                => $this->when(in_array('make_and_model', $returnFields), $this->hardwareStandard ?? ''),
            'platform'                      => $this->when(in_array('mac_address', $returnFields), $this->mac ?? ''),
            'mac_address'                   => $this->when(in_array('mac_address', $returnFields), $this->mac ?? ''),
            'host_name'                     => $this->when(in_array('host_name', $returnFields), $this->host_name ?? ''),

            'lock_status'                   => $this->when(in_array('lock_status', $returnFields), $this->lock_status ?? ''),
            'lock_notes'                    => $this->when(in_array('lock_notes', $returnFields), $this->lock_notes ?? ''),
            'unlock_code'                   => $this->when(in_array('unlock_code', $returnFields), $this->unlock_code ?? ''),
            'linked_date'                   => $this->when(in_array('linked_date', $returnFields), $this->linked_date ?? ''),
            'lost_date'                     => $this->when(in_array('lost_date', $returnFields), $this->lost_date ?? ''),
            'end_of_life_date'              => $this->when(in_array('end_of_life_date', $returnFields), $this->end_of_life_date ?? ''),
            'wipe_confirmation'             => $this->when(in_array('wipe_confirmation', $returnFields), $this->wipe_confirmation ?? ''),
            'donation_certificate'          => $this->when(in_array('donation_certificate', $returnFields), $this->donation_certificate ? url("/downloadcertificate/" . str_replace('/', '-', $this->donation_certificate)) : ''),

            'modified_by'                   => $this->when(in_array('modified_by', $returnFields), optional(optional($this->latestAssetHistory)->user)->first_name . ' ' . optional(optional($this->latestAssetHistory)->user)->last_name),
            'created_by'                    => $this->when(in_array('created_by', $returnFields), $this->assetHistoryCreated ? optional($this->assetHistoryCreated->user)->user_name : ''),
            'last_status_update'            => $this->when(in_array('last_status_update', $returnFields), $this->last_status_update ?? ''),
            'last_logged_user'              => $this->when(in_array('last_logged_user', $returnFields), $this->endPointLastLoggedUser ?? ''),
            'last_seen'                     => $this->when(in_array('last_seen', $returnFields), ($this->lastSeen && $this->lastSeen != '11/30/-0001 12:00:00 AM') ? $this->lastSeen : ''),

            'asset_type_details'            => $this->when(in_array('asset_type_details', $returnFields), new AssetTypeResource($this->assetType)),
            'asset_status_details'          => $this->when(in_array('asset_status_details', $returnFields), new AssetStatusResource($this->assetStatus)),
            'carrier_details'               => $this->when(in_array('carrier_details', $returnFields), new CarrierResource($this->carrier)),
            'user_details'                  => $this->when(in_array('user_details', $returnFields), new UserResource($this->user)),
            'location_details'              => $this->when(in_array('location_details', $returnFields), new LocationResource($this->location)),
            'techspec_details'              => $this->when(in_array('tech_spec_details', $returnFields), new TechSpecRelationResource($this->technicalSpec)),
            'hardware_details'              => $this->when(in_array('hardware_details', $returnFields), new HardwareRelationResource($this->makeAndModel)),
            'manufacturer_details'          => $this->when(in_array('manufacturer_details', $returnFields), new ManufacturerResource(optional($this->makeAndModel)->manufacturer)),
        ];
    }
}
