<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ValidationsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'serial_no' => ['nullable', 'required_without:asset_tag', 'string', 'regex:/^[a-zA-Z0-9\-\_\(\)\+\/\# ]+$/'],
            'asset_tag' => ['nullable', 'required_without:serial_no', 'string', 'regex:/^[a-zA-Z0-9\-\_\(\)\+\/\# ]+$/']
        ];
    }
}
