<?php

namespace App\Http\Requests;

use App\Models\UserType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Route;

class UpdateUser extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $validUserTypeIds = UserType::userRoles()->pluck('id')->toArray();

        return [
            'user_type_id' => [
                'required',
                'integer',
                Rule::in($validUserTypeIds),
            ],
        ];
    }

    public function messages()
    {
        return [
            'user_type_id.required' => 'Teqtivity Role is required',
            'user_type_id.in' => 'You are not allowed to assign Super Admin or Super User roles.',
        ];
    }
}
