<?php

namespace App\Http\Requests\TeqtivityUsers;

use App\Models\UserType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Str;

class StoreTeqtivityUser extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        if (request()->has('password')) {
            return [
                'email' => 'required|unique:users',
            ];
        }
        return [
            'email' => 'required|unique:users',
        ];
    }

    public function messages()
    {
        return [
            'email.unique' => 'Email already taken',
        ];
    }

    /**
     * Prepare the data for validation.
     *
     * @return void
     */
    protected function prepareForValidation()
    {
        $this->merge(
            [
                'password' =>  Str::random(16),
                'user_type_id' => UserType::where('name', 'Super Admin')->first()->id,
                'first_name' => "TEQ",
                'last_name' => 'Support',
                'status' => 1
            ]
        );
    }
}
