<?php

namespace App\Http\Requests\SystemSettings;

use Illuminate\Foundation\Http\FormRequest;

class DocumentationRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'help_guide_url'                    => 'required|url',
            'api_guide_url'                     => 'required|url',
            'help_guide_authentication_token'   => 'nullable',
            'api_guide_authentication_token'    => 'nullable',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'help_guide_url.required'                   => 'Help Guide URL field is required',
            'help_guide_url.url'                        => 'Help Guide URL format is invalid',
            'api_guide_url.required'                    => 'API Guide URL field is required',
            'api_guide_url.url'                         => 'API Guide URL format is invalid'
        ];
    }
}
