<?php

namespace App\Http\Requests;

use App\Models\UserType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreUser extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // Fetch all valid user_type_ids from DB (to ensure valid IDs)
        $validUserTypeIds = UserType::userRoles()->pluck('id')->toArray();

        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|unique:users',
            'employee_id' => 'required|unique:users',
            'user_type_id' => [
                'required',
                'integer',
                Rule::in($validUserTypeIds),
            ],
            //'position_id' => 'required',
            // 'employee_type' => 'required',
            // 'business_title' => 'required',
            'hire_date' => 'required'
        ];
    }

    /**
     * Get the validation messages that apply to the request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'first_name.required' => 'Please Enter First Name',
            'last_name.required' => 'Please Enter Last Name',
            'employee_type.required' => 'Please Enter User Type',
            // 'business_title.required' => 'Please Enter Title',
            'email.required' => 'Please Enter the E-mail',
            'email.unique' => 'The Email is Already Taken',
            'employee_id.required' => 'Please Enter the Employee ID',
            'user_type_id.required' => 'Please Select User Type',
            'user_type_id.in' => 'You are not allowed to assign Super Admin or Super User roles.',
            //'position_id.required' => 'Please Select Employee Position',
            // 'employee_type_id.required' => 'Please Select Employee Type',
            'hire_date.required' => 'Please Select Hire Date',
        ];
    }
}
