<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Route;

class StoreLocation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $location = Route::input('location');
        if ($location) {
            return [
                'room_name' => 'required|unique:locations,room_name,' . $location,
                'status' => 'boolean',
            ];
        } else {
            return [
                'location_type_id' => 'required|exists:location_types,id',
                'room_name' => 'required|unique:locations',
                'site_code_id' => 'required',
                'address' => 'required',
                'floor' => 'required',
                'status' => 'boolean',
            ];
        }
    }

    public function messages()
    {
        return [
            'location_type_id.required' => 'The room type is required',
            'room_name.unique' => 'Name already exists',
            'state_id.required' => 'State is required',
            'location_type_id.exists' => 'Invalid location type selected',
        ];
    }
}
