<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreDiscoveryToolsHardwareMapping extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'make_and_model'    => ['required'],
            'intune_model'    => ['required_without_all:chrome_model,jamf_model,workspace_one_model, kandji_model, mobile_iron_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'intune_model');
                })],

            'chrome_model'    => ['required_without_all:intune_model,jamf_model,workspace_one_model, kandji_model, mobile_iron_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'chrome_model');
                })],

            'jamf_model'    => ['required_without_all:chrome_model,intune_model,workspace_one_model, kandji_model, mobile_iron_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'jamf_model');
                })],

            'workspace_one_model'    => ['required_without_all:chrome_model,jamf_model,intune_model, kandji_model, mobile_iron_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'workspace_one_model');
                })],

            'kandji_model'    => ['required_without_all:chrome_model,jamf_model,intune_model,workspace_one_model,mobile_iron_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'kandji_model');
                })],
            'mobile_iron_model'    => ['required_without_all:chrome_model,jamf_model,intune_model, kandji_model,workspace_one_model', Rule::unique('discovery_tools_hardware_mappings', 'mdm_model')
                ->where(function ($query) {
                    return $query->where('mdm_name', 'mobile_iron_model');
                })],
        ];
    }

    public function messages()
    {
        return [];
    }
}
