<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreAssetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'location_id'       => ['required', 'exists:locations,id'],
            'asset_type_id'     => ['required', 'exists:asset_types,id'],
            'asset_tag'         => ['required', 'unique:assets', 'regex:/^[a-zA-Z0-9\-\_\(\)\+\/\# ]+$/'],
            'serial_no'         => ['required', 'unique:assets', 'regex:/^[a-zA-Z0-9\-\_\(\)\+\/\# ]+$/'],
            // 'ticket_no'         => ['required'],
            'po_id'             => ['required'],
            'make_and_model_id' => ['required', 'exists:make_and_models,id'],
            'technical_spec_id' => ['required', 'exists:technical_specs,id'],
            'vendor_id'         => ['nullable', 'exists:vendors,id']
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'location_id.required'       => 'The location is required',
            'asset_type_id.required'     => 'The asset type is required',
            'asset_tag.required'         => 'The asset tag is required',
            'asset_tag.unique'           => 'The asset tag has already been taken',
            'asset_tag.regex'            => 'The Asset Tag contains invalid characters.',
            'serial_no.required'         => 'The serial number is required',
            'serial_no.unique'           => 'The serial number has already been taken',
            'serial_no.regex'            => 'The Serial # contains invalid characters.',
            'ticket_no.required'         => 'The ticket number is required',
            'location_id.exists'         => 'Invalid location selected',
            'po_id.required'             => 'The PO # is required ',
            'make_and_model_id.required' => 'The hardware standard is required',
            'make_and_model_id.exists'  => 'The hardware standard does not exists',
            'vendor_id.exists'           => 'The vendor does not exists',
            'technical_spec_id.exists'  => 'The technical specs does not exists',
        ];
    }
}
