<?php

namespace App\Http\Requests;

use App\Rules\ValidateFileExtension;
use Illuminate\Foundation\Http\FormRequest;

class SpecialUpload extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $extension = '';
        $file = $this->file('bulk_upload_asset');

        if ($file) {
            $extension = strtolower($file->getClientOriginalExtension());
        }

        return [
            'bulk_upload_asset' => ['required', new ValidateFileExtension($extension, ['csv'])]
        ];
    }

    public function messages()
    {
        return [];
    }
}
