<?php

namespace App\Http\Requests\SoftwareLicense;

use Illuminate\Foundation\Http\FormRequest;
use Route;

class SoftwareLicenseManufacturerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->action != 'edit') {
            return [
                'manufacturer_id' => 'required',
            ];
        }
        return [
            'name' => 'required|unique:software_license_manufacturers,name,' . $this->manufacturer_id,
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'The manufacturer name is required',
            'name.unique' => 'Manufacturer already exists',
        ];
    }
}
