<?php

namespace App\Http\Requests\SoftwareLicense;

use Illuminate\Foundation\Http\FormRequest;
use Route;

class SoftwareLicenseCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->action != 'edit') {
            return [
                'category_id' => 'required',
            ];
        }
        return [
            'name' => 'required|unique:software_license_categories,name,' . $this->category_id,
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'The category name is required',
            'name.unique' => 'Category already exists',
        ];
    }
}
