<?php

namespace App\Http\Requests\SoftwareLicense;

use Illuminate\Foundation\Http\FormRequest;

class LicenseDocumentRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }


    public function rules()
    {
        return [
            'software_liceneses_documents.*' => 'file|mimes:pdf|max:5120',
        ];
    }

    public function messages()
    {
        return [
            'software_liceneses_documents.*.file' => 'Each uploaded document must be a file.',
            'software_liceneses_documents.*.mimes' => 'Each document must be a PDF.',
            'software_liceneses_documents.*.max' => 'Each document must not be greater than 5MB.',
        ];
    }
}
