<?php
namespace App\Http\Requests\Slack;

use Illuminate\Foundation\Http\FormRequest;
class SlackCredentialsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [            
            'app_key'    => 'required',
            'app_secret' => 'required',
        ];
    }
    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'app_key.required' => 'Client ID field is required',
            'app_secret.required' => 'Client secret field is required',
        ];
    }
}