<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ShareViaEmailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    protected function prepareForValidation()
    {
        $this->merge(['users' => explode(',', rtrim($this->users, ','))]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'file_name' => ['required'],
            'users.*' => ['required', 'email'],
            'title' => ['required'],
        ];
    }

    public function messages()
    {
        return [
            'file_name.required' => 'File is missing .Please try again',
        ];
    }
}
