<?php

namespace App\Http\Requests\Settings\Zoom;

use Illuminate\Foundation\Http\FormRequest;

class ZoomHardwareCredentialsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'client_id'    => 'required',
            'client_secret' => 'required',
        ];
    }
    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'client_id.required' => 'Client ID is required',
            'client_secret.required' => 'Client Secret is required',
        ];
    }
}
