<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RevivnUpdateAssetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id'                => 'required',
            'asset_type_id'     => 'required',
            'make_and_model_id' => 'required',
            'technical_spec'    => 'required',
        ];
    }

    /**
     * Get the validation messages that apply to the rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'make_and_model_id.required' => 'Hardware Standard is required.',
            'id.required'                => 'Something went wrong. Try again',
            'asset_type_id.required'     => 'Asset type is required.',
            'technical_spec.required'    => 'Technical spec is required.',
        ];
    }
}
