<?php

namespace App\Http\Requests\Retreiver;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreRetreiverShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule','array<mixed>','string>
     */
    public function rules(): array
    {
        return [
            'request_charger'        => ['nullable', 'boolean'],
            'request_cell_phone'     => ['nullable', 'boolean'],
            'device'                 => ['required', 'string', Rule::in(array_keys(config('retriever.device_types')))],
            'request_disposal'       => ['nullable', 'boolean'],
            'email'                  => ['nullable', 'email', 'max:128'],
            'name'                   => ['required', 'string', 'max:64'],
            'address_line_1'         => ['required', 'string', 'max:128'],
            'address_line_2'         => ['nullable', 'string', 'max:128'],
            'address_city'           => ['required', 'string', 'max:128'],
            'address_state'          => ['required', 'string', 'max:32'],
            'address_zip'            => ['required', 'string', 'max:32'],
            'address_country'        => ['required', 'string', 'max:32'],
            'return_recipient_name'  => ['required', 'string', 'max:64'],
            'return_address_company' => ['nullable', 'string', 'max:64'],
            'return_address_line_1'  => ['required', 'string', 'max:128'],
            'return_address_line_2'  => ['nullable', 'string', 'max:128'],
            'return_address_city'    => ['required', 'string', 'max:128'],
            'return_address_state'   => ['required', 'string', 'max:32'],
            'return_address_zip'     => ['required', 'string', 'max:32'],
            'display_name'           => ['required', 'string', 'max:64'],
            'notification_email'     => ['nullable', 'email', 'max:128'],
            'return_address_country' => ['required', 'string', 'max:32'],
        ];
    }
}
