<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GoogleWorkspaceClientSecretRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            'client_secrete' => 'required|file|max:1024',
            'admin_email' => 'required|email', // Added email validation for admin_email
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return [
            'client_secrete.required' => 'Client Secret file is required',
            'client_secrete.file' => 'Client Secret file must be a valid file',
            'client_secrete.max' => 'Client Secret file must not exceed 1MB',
            'admin_email.required' => 'Admin Email is required',
            'admin_email.email' => 'Admin Email must be a valid email address',
        ];
    }
}
