<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AssetValidation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'asset_id' => 'required|integer',
            'status_id' => 'required|integer',
        ];
    }

    public function messages()
    {
        return [
            'asset_id.required' => 'The Asset field is required',
            'status_id.required' => 'The Asset Status is required',
            'user_id.required' => 'The User is required ',
        ];
    }
}
