<?php

namespace App\Http\Requests;

use App\Models\AssetStatus;
use Illuminate\Foundation\Http\FormRequest;

class AssetStatusUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $assetStatus = AssetStatus::find($this->status_id) ?? null;

        // Base validation rules
        $rules = [
            'asset_id' => ['required', 'integer'],
            'asset_status_id' => ['required', 'integer'],
        ];

        // Add conditional rules based on asset status

        if ($assetStatus?->has_location == 1) {
            $rules['location_id'] = ['required', 'integer'];
        }

        if ($assetStatus?->has_user == 1) {
            $rules['user_id'] = ['required', 'integer'];
        }


        return $rules;
    }

    public function messages()
    {
        return [
            'asset_id.required' => 'The Asset field is required',
            'status_id.required' => 'The Asset Status is required',
            'user_id.required' => 'The User is required ',
            'location_id.required' => 'The Location is required ',
        ];
    }
}
