<?php

namespace App\Http\Requests\Asn\Presidio;

use Illuminate\Foundation\Http\FormRequest;

class StoreAsnHardwareMapping extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool Always returns true, allowing any user to make this request.
     */

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     *
     * Rules:
     * - part_no: required
     * - make_and_model: required
     * - technical_spec: required
     */
    public function rules()
    {
        return [
            'part_no'           => 'required',
            'make_and_model'    => 'required',
            'technical_spec'    => 'required'
        ];
    }

    /**
     * Return the error messages for the validation.
     *
     * @return array The error messages.
     */
    public function messages()
    {
        return [
            'part_no.required'          => 'The part # is required',
            'make_and_model.required'   => 'Hardware Standard is required.',
            'technical_spec.required'   => 'Tech Specs is required.',
        ];
    }
}
