<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class GetUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation()
    {

        foreach (config('api-filter-fields.users.filter_fields') as $key) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.users.filter_mapping_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.users.filter_fields_bool') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.users.relational_filter_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.users.filter_date_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'limit'                          => ['nullable', 'numeric'],
            'page'                           => ['nullable', 'numeric'],
            'first_name.*'                   => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'last_name.*'                    => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'employee_id.*'                  => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'email.*'                        => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i'],
            'work_location.*'                         => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'teqtivity_role.*'                    => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'department.*'                   => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'position.*'                     => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'user_type.*'                => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'created_date.*'                 => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'hire_date.*'                    => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'terminated_date.*'              => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'modified_date.*'                => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'status.*'                         => 'nullable|in:Active,Terminated',
            'legalhold.*'                         => 'nullable|in:Yes,No',

        ];
    }

    public function messages()
    {
        return [];
    }
}
