<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class GetHardwareRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation()
    {

        foreach (config('api-filter-fields.hardwareStandards.filter_fields') as $key) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.hardwareStandards.relational_filter_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.hardwareStandards.filter_date_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'limit'                               => ['nullable', 'numeric'],
            'page'                                => ['nullable', 'numeric'],
            'name.*'                              => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'manufacturer.*'                      => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'asset_type.*'                        => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'created_date.*'                      => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'modified_date.*'                     => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],

        ];
    }

    public function messages()
    {
        return [];
    }
}
