<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class GetAssetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation()
    {

        foreach (config('api-filter-fields.assets.filter_fields') as $key) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.assets.relational_filter_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.assets.filter_date_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }

        foreach (config('api-filter-fields.assets.relational_date_fields') as $key => $value) {
            if ($this->has($key)) {
                $this->merge([$key => $this->$key ? explode(',', $this->$key) : []]);
            }
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'limit'                        => ['nullable', 'numeric'],
            'page'                         => ['nullable', 'numeric'],
            'selected_columns'             => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'asset_tag.*'                  => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'serial_no.*'                  => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'po_no.*'                      => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'imei.*'                       => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'ticket_no.*'                  => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'wipe_confirmation.*'          => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'host_name.*'                  => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'asset_tracking_id.*'          => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'asset_status.*'               => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'asset_type.*'                 => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'user.*'                       => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i'],
            'location.*'                   => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'manufacturer.*'               => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'carrier.*'                    => ['nullable', 'regex:/^[a-z0-9, _-]+$/i'],
            'created_date.*'               => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'warranty_end_date.*'          => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'certificate_added_date.*'     => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'end_of_life_date.*'           => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'lost_date.*'                  => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'linked_date.*'                => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'loaner_retention_date.*'      => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'lease_end_date.*'             => ['nullable', 'date', 'date_format:' . config('date.formats.read_date_format')],
            'loaner_return_date.*'         => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'lease_start_date.*'           => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'modified_date.*'              => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'hire_date.*'                   => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'terminated_date.*'             => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'terminated_date_from'          => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format')],
            'terminated_date_to'            => ['nullable', 'date',  'date_format:' . config('date.formats.read_date_format'), 'after_or_equal:terminated_date_from'],
        ];
    }

    public function messages()
    {
        return [];
    }
}
