<?php

namespace App\Http\Middleware;

use Closure;

class XSSProtection
{
    /**
     * Handle an incoming request.
     *
     * This middleware sanitizes user input to prevent Cross-Site Scripting (XSS) attacks.
     * It removes potentially harmful HTML and JavaScript tags from request input fields,
     * except for those explicitly excluded from sanitization.
     *
     * @param  \Illuminate\Http\Request  $request  The incoming HTTP request instance.
     * @param  \Closure  $next  The next middleware in the pipeline.
     *
     * @return mixed  The HTTP response after processing the middleware.
     */
    public function handle($request, Closure $next)
    {
        // Only apply sanitization for PUT and POST requests, as these typically contain user-submitted data.
        if (!in_array(strtolower($request->method()), ['put', 'post'])) {
            return $next($request);
        }

        // List of fields to exclude from sanitization, e.g., sensitive data like passwords.
        $excludedFields = ['password', 'password_confirmation'];

        // Retrieve all input data from the request.
        $input = $request->all();

        // Traverse all input fields recursively and sanitize them.
        array_walk_recursive($input, function (&$input, $key) use ($excludedFields) {
            // Only sanitize fields not in the excluded list.
            if (!in_array($key, $excludedFields) && $input) {
                $input = strip_tags($input);
            }
        });

        // Replace the original request data with the sanitized input.
        $request->merge($input);

        // Proceed to the next middleware or request handler.
        return $next($request);
    }
}
