<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SecurityAndCacheHeaders
{

    /**
     * Handle an incoming request.
     *
     * This middleware sets security headers and cache-control headers
     * to ensure secure and non-cacheable responses.
     *
     * @param  Request   $request  The HTTP request instance.
     * @param  \Closure  $next     The next middleware or request handler.
     *
     * @return \Illuminate\Http\Response  The HTTP response with security and cache-control headers set.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Set security headers.
        // Commented because of error: $response->headers->set('Content-Security-Policy', "default-src 'self'; script-src 'self'");.
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('X-Frame-Options', 'DENY');
        $response->headers->set('X-XSS-Protection', '1; mode=block');

        // Set cache control headers.
        $response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0');
        $response->headers->set('Pragma', 'no-cache');
        $response->headers->set('Expires', 'Thu, 01 Jan 1970 00:00:00 GMT');

        return $response;
    }
}
