<?php

namespace App\Http\Middleware;

use Closure;
use Firebase\JWT\JWT;
use Illuminate\Http\Request;
use App\Models\ApiCredential;

class ScimAuthenticationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!$request->hasHeader('Authorization')) {
            return $this->unauthorizedResponse();
        }

        $token = $this->getTokenFromHeader($request);

        if (!$token) {
            return $this->unauthorizedResponse();
        }

        $oktaScim = ApiCredential::whereSlug('okta_scim')->whereNotNull('key')->first();

        if (!$oktaScim)
        {
            return $this->unauthorizedResponse();
        }

        if ($token != $oktaScim->key)
        {
            return $this->unauthorizedResponse();
        }

        return $next($request);
    }

    /**
     * Extract the token from the Authorization header.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function getTokenFromHeader(Request $request): ?string
    {
        $header = $request->header('Authorization');

        if (preg_match('/^Bearer\s+(.*)$/i', $header, $matches)) {
            return $matches[1];
        }

        return null;
    }

    /**
     * Create an unauthorized response.
     *
     * @return \Illuminate\Http\Response
     */
    protected function unauthorizedResponse()
    {
        return response('Unauthorized', 401);
    }
}
