<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Traits\UnauthenticatedApiIpTrait;

class CheckUntrustedIPsMiddleware
{
    // This method handles an incoming request.
    // It checks if the request is an API request, and if so, it checks if the IP of the request is blocked.
    // If the IP is blocked, it returns a JSON response indicating that the access is blocked.
    // Otherwise, it forwards the request to the next middleware.

    use UnauthenticatedApiIpTrait;

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if it's an API request before checking blocked IP
        if (!$request->expectsJson()) {
            return response()->json([
                'success'       => false,
                'message'       => "API requests must include an Accept: application/json header.",
                'status_code'   => 400,
                'data'          => []
            ], 400);
        }

        $blocked = $this->checkIsIpBlocked(getIp());

        if ($blocked) {
            return response()->json([
                'success'           => false,
                'message'           => "You are blocked to access this resource!",
                'status_code'       => 401,
                'data'              => []
            ], 401);
        }

        return $next($request);
    }
}
