<?php

namespace App\Http\Middleware;


use Closure;
use Illuminate\Http\Request;
use Laravel\Passport\Token;
use App\Events\CreateApiRequestHistory;
use App\Models\ApiClient;
use Carbon\Carbon;

class ApiRequestLog
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $clientId = "";
        if ($request->has('client_id')) {
            $clientId = ApiClient::where('uuid', $request->client_id)->first()->id;
        }

        $bearerToken = $request->bearerToken();
        if ($bearerToken) {
            $clientId = auth('api')->client()->id;
        }

        $logData = [
            'client_id' => $clientId,
            'api_url' => $request->getPathInfo(),
            'request_ip' => getIp(),
            'request_data' => serialize($request->all()),
            'request_method' => $request->getMethod(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ];

        event(new CreateApiRequestHistory($logData));
        return $next($request);
    }
}
