<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Facades\App\Services\SearchAsset;

class UserFilterFieldController extends Controller
{
    /**
     * Get the filtered user fields based on the search query
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the search results
     */
    public function getFilterUserFields()
    {
        $search = request('search');

        if (!empty($search)) {
            $result = SearchAsset::getFilterUserFields($search);

            return response()->json($result);
        }
    }


    /**
     * Get the teqtivity department
     * @return [type]
     */
    public function getFilterUserDepartmentFields()
    {
        $search = request('search');

        if (!empty($search)) {

            $result = SearchAsset::getFilterUserDepartmentFields($search);

            return response()->json($result);
        }
    }

    /**
     * Get the filtered user fields based on the search query for all users.
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the search results
     */
    public function getFilterAllUserFields()
    {
        $search = request('search');

        if (!empty($search)) {

            $result = SearchAsset::getFilterAllUserFields($search);

            return response()->json($result);
        }
    }

    /**
     * Get the filtered user fields based on the search query for assigned users.
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the search results
     */
    public function getFilterAssignedUserFields()
    {
        $search = request('search');

        if (!empty($search)) {

            $result = SearchAsset::getFilterAssignedUserFields($search);

            return response()->json($result);
        }
    }
}
