<?php

namespace App\Http\Controllers;

use App\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ThemeSwitchController extends Controller
{
    /**
     * Toggle the user's theme preference.
     *
     * @param Request $request The request object
     *
     * @return bool Returns true if the operation was successful, false otherwise
     */
    public function toggle(Request $request)
    {
        $theme = $request->theme;

        if (! in_array($theme, ['light', 'dark'])) {
            return false;
        }

        try {
            $user = User::find(auth()->id());
            $user->theme_preference = $theme;
            $user->save();

            // Refresh the authenticated user's data
            Auth::user()->refresh();

            return true;
        } catch (Exception $e) {
            return false;
        }
    }
}
