<?php

namespace App\Http\Controllers\Terminations\HrCollection;

use App\Http\Controllers\Controller;
use App\Services\Terminations\HrCollection\UserStatisticsGraphService;

class UserStatisticsGraphController extends Controller
{
    protected $service;

    public function __construct(UserStatisticsGraphService $service)
    {
        $this->service = $service;
    }

    /**
     * shows user statistics graph of terminated users
     */
    public function index()
    {
        $data = $this->service->generateGraphData();
        $months = $data['monthNames'] ?? [];
        $lastYearGraphData = $data['lastYearData'] ?? [];
        $currentYearGraphData = $data['currentYearData'] ?? [];

        return view('terminations.terms-report.user-statistics-graph', compact('months', 'currentYearGraphData', 'lastYearGraphData'));
    }
}
